" Unit 4 - Lecture 3 "
"------------------------------------------------------------------------"

" Principal Component Analysis "

# Syntax:
princomp(<Data>)

# Creating Multiple Scatter Plots
plot(mtcars[,1:5])

# Correlation Matrix
cor(mtcars[,1:5])


Model = princomp(mtcars[,1:5])

# Proportion of variability explained by each component
summary(Model)


G = data.frame(matrix(runif(100,-10000,10000),
                      nrow = 10))
cor(G)

model.G = princomp(G)
summary(model.G)

# Scree Plot
plot(Model,type = "l")

"------------------------------------------------------------------------"

" Correlation Test "

"
Recall:

Pearson's Correlation Coefficient
Spearman's Correlation Coefficient
Kendall's Correlation Coefficient

"

X = 1:50
Y = exp(X + runif(length(X),-10,10))

plot(X,Y)

cor(X,Y)
cor(X,Y,method = "spearman")
cor(X,Y,method = "kendall")

"
H0: Rho = 0
H1: Rho != 0
"
cor.test(X,Y,method = "kendall")


"------------------------------------------------------------------------"

" Maximum Likelihood Estimate  "

set.seed(1)
X = rexp(1000,0.25)


"
L = prod(f(xi))
log(L) = sum(log(f(xi)))

dlog(L) / dlambda = 0

Note:
f(x)

"

MLE.Lambda = function(para){
  
  - sum(log(dexp(X,para)))
  
}


nlm(MLE.Lambda,1 / mean(X))

NLL = c()
D = seq(0.225,0.253,0.001)

for(i in 1:length(D)){
  
  NLL[i] = MLE.Lambda(D[i])
  
}

plot(D,NLL)

D[which.min(NLL)]
abline(v = D[which.min(NLL)],
       col = "red")


" For 2 unknown parameters "

X = rnorm(1000,5,2)


MLE.Lambda = function(para){
  
  - sum(log(dnorm(X,para[1],para[2])))
  
}

nlm(MLE.Lambda,c(mean(X),sd(X)))$estimate


"------------------------------------------------------------------------"

" Transformation of Variables  "

model = lm(mpg ~ log(wt),mtcars)

mtcars$wt.log = log(mtcars$wt) 


"------------------------------------------------------------------------"
